package w83b.w83bOperacionesPaso.w83bMantenimientos.w83bSindicatos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bSindicatosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

// TODO: Auto-generated Javadoc
/**
 * The Class W83bTablaConveniosOP.java.
 *
 * @author Deusto Sistemas
 */
public class W83bTablaSindicatosExcelAction extends Q70ActionPasoOP{


	/**
	 * processOP.
	 *
	 * @param contexto a
	 * @param errores a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @throws Exception e
	 */	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}
	
	/**
	 * processForward.
	 *
	 * @param contexto a
	 * @param errors a
	 * @param mapping a
	 * @param form a
	 * @param request a
	 * @param response a
	 * @return ActionForward
	 * @throws Exception e
	 */	
	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoSindicatos.xls";
		InputStream inputStream = W83bTablaSindicatosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream);
		
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaSindicatos = (ArrayList)contexto.get("w83bListaSindicatos");
        W83bSindicatosBean sindicatoBean = (W83bSindicatosBean)contexto.get("w83bSindicatosTempBean");                
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);                
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);                
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);                
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));                
        HashMap mapaSindicatos=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);                
       
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1                
        HSSFCell cell = row.createCell((short)3);                
        row = sheet.getRow((short)4);                
        cell = row.getCell((short)5);                
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaSindicatos.get("tituloDepEs");                
        StringBuffer tituloImagenEu =  (StringBuffer)mapaSindicatos.get("tituloDepEu");                
        cell.setCellValue(tituloImagenEu.toString());                
        
        cell = row.getCell((short)9);                
        cell.setCellValue(tituloImagenEs.toString());                
        
        tituloImagenEs = (StringBuffer)mapaSindicatos.get("tituloDelelegacionEs");                
        tituloImagenEu = (StringBuffer)mapaSindicatos.get("tituloDelelegacionEu");                

        row = sheet.getRow((short)6);                
        cell = row.getCell((short)5);                
        cell.setCellValue(tituloImagenEu.toString());                
        
        cell = row.getCell((short)9);                
        cell.setCellValue(tituloImagenEs.toString());                
        
        row = sheet.getRow((short)9);                
        cell = row.getCell((short)0);                
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.convenios.listadoSindicatos").toUpperCase());                
        
        //MAPEO FORMULARIO
        row = sheet.getRow(Short.parseShort("12")); 
	        cell = row.getCell(Short.parseShort("1"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codSindicato"));
	        cell = row.createCell(Short.parseShort("2"));
	        if(!StringUtils.isEmpty(sindicatoBean.getCodSindicato())){
	        	cell.setCellValue(W83bUtilidades.numero(sindicatoBean.getCodSindicato()));
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	        
	        cell = row.getCell(Short.parseShort("4"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.siglas"));
	        cell = row.createCell(Short.parseShort("7"));
	        if(!StringUtils.isEmpty(sindicatoBean.getSiglas())){
	        	sheet.addMergedRegion(new Region(W83bClsConstantes.DOCE,Short.parseShort("7"),W83bClsConstantes.DOCE,Short.parseShort("8")));//NOPMD
	        	cell.setCellValue(sindicatoBean.getSiglas().toUpperCase());
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	        
	    	cell = row.getCell(Short.parseShort("9"));
	    	cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codVerificacion"));
	        cell = row.createCell(Short.parseShort("11"));
	        if(!StringUtils.isEmpty(sindicatoBean.getCodVerificacion())){
	        	cell.setCellValue(W83bUtilidades.numero(sindicatoBean.getCodVerificacion()));
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	        
	        cell = row.getCell(Short.parseShort("12"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codMadrid"));
	        cell = row.createCell(Short.parseShort("14"));
	        if(!StringUtils.isEmpty(sindicatoBean.getCodMadrid())){
	        	cell.setCellValue(W83bUtilidades.numero(sindicatoBean.getCodMadrid()));
	        	cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.DOCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	        
        row = sheet.getRow(Short.parseShort("13")); 
	        cell = row.getCell(Short.parseShort("1"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.altaStes"));
	        cell = row.createCell(Short.parseShort("2")); 
	        if (W83bClsConstantes.CONSTANTE_SI.equals(sindicatoBean.getStes())){
	        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());

			}
			else if (W83bClsConstantes.CONSTANTE_NO.equals(sindicatoBean.getStes())){
				cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());

			}
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
	        
	        cell = row.getCell(Short.parseShort("4"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.descSindicatoCast"));
	        cell = row.createCell(Short.parseShort("7"));
	        if(!StringUtils.isEmpty(sindicatoBean.getDescSindicatoCast())){
		        sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("7"),W83bClsConstantes.TRECE,Short.parseShort("14")));//NOPMD
		        cell.setCellValue(sindicatoBean.getDescSindicatoCast().toUpperCase());
		        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.TRECE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	       
        row = sheet.getRow(Short.parseShort("14")); 
	        cell = row.getCell(Short.parseShort("1"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.herramientas.baja"));
	        cell = row.createCell(Short.parseShort("2"));
	        if (StringUtils.isEmpty(sindicatoBean.getBaja())||W83bClsConstantes.ALTA.equals(sindicatoBean.getBaja())){
	        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase());

	        }else{
	        	cell.setCellValue(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase());

	        }
	        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
	        
	        cell = row.getCell(Short.parseShort("4"));
	        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.descSindicatoEusk"));
	        cell = row.createCell(Short.parseShort("7"));
	        if(!StringUtils.isEmpty(sindicatoBean.getDescSindicatoEusk())){
		        sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("7"),W83bClsConstantes.CATORCE,Short.parseShort("14")));//NOPMD
		        cell.setCellValue(sindicatoBean.getDescSindicatoEusk().toUpperCase());
		        cell.setCellStyle(this.estiloFilaJustificado(W83bClsConstantes.CATORCE,excel,wb));
	        }else{
	        	cell.setCellValue("");
	        }
	       
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow(Short.parseShort("17"));
        cell = row.getCell(Short.parseShort("0"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codSindicato"));
        
        cell = row.getCell(Short.parseShort("1"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.descSindicatoCast"));
        
        cell = row.getCell(Short.parseShort("4"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.descSindicatoEusk"));
        
        cell = row.getCell(Short.parseShort("9"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.siglas"));
        
        cell = row.getCell(Short.parseShort("10"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codVerificacion"));
        
        cell = row.getCell(Short.parseShort("12"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.codMadrid"));
        
        cell = row.getCell(Short.parseShort("13"));
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.sindicatos.altaStes"));
       
        for(int i=0;i<listaSindicatos.size();i++){
        	row = sheet.createRow((short)W83bClsConstantes.DIECIOCHO+i); // Creacin de la fila 1//NOPMD
        	
        	//Cod Sindicato
        	cell = row.createCell(Short.parseShort("0")); 
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getCodSindicato())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bSindicatosBean)listaSindicatos.get(i)).getCodSindicato()));
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	//Descripcin sindicato Castellano
        	cell = row.createCell(Short.parseShort("1"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("1"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("3")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast())){
        		cell.setCellValue(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("2")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("3")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	//Descripcin sindicato Euskera
        	cell = row.createCell(Short.parseShort("4"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("4"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("8")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk())){
        		cell.setCellValue(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("5")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("6")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("7")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	cell = row.createCell(Short.parseShort("8")); 
        	cell.setCellStyle(this.estiloFila(i,excel));
        	//Siglas
        	cell = row.createCell(Short.parseShort("9"));
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getSiglas())){
        		cell.setCellValue(((W83bSindicatosBean)listaSindicatos.get(i)).getSiglas());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFila(i,excel));
        	
        	//Cod. verificacin
        	cell = row.createCell(Short.parseShort("10"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("10"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("11")));//NOPMD
        	if(!StringUtils.isEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getCodVerificacion())){
	        	cell.setCellValue(W83bUtilidades.numero(((W83bSindicatosBean)listaSindicatos.get(i)).getCodVerificacion()));
	        }else{
	        	cell.setCellValue("");
	        }
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("11")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	//Cod. Madrid
        	cell = row.createCell(Short.parseShort("12"));
        	if(!StringUtils.isEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getCodMadrid())){
	        	cell.setCellValue(W83bUtilidades.numero(((W83bSindicatosBean)listaSindicatos.get(i)).getCodMadrid()));
	        }else{
	        	cell.setCellValue("");
	        }
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	//Alta stes
        	cell = row.createCell(Short.parseShort("13"));
        	sheet.addMergedRegion(new Region(W83bClsConstantes.DIECIOCHO+i,Short.parseShort("13"),W83bClsConstantes.DIECIOCHO+i,Short.parseShort("14")));//NOPMD
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getStes())){
        		cell.setCellValue(((W83bSindicatosBean)listaSindicatos.get(i)).getStes().toUpperCase());
        	}else{
        		cell.setCellValue("");
        	}
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	cell = row.createCell(Short.parseShort("14")); 
        	cell.setCellStyle(this.estiloFilaNumeroCentrado(i,excel));
        	if(StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast()) 
        			&& StringUtils.isNotEmpty(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk())){
	        	if((((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast()).length()>=(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk()).length()){
		        	if(67<(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoCast()).length()/67)+1));
		        	}
		        }else{
		        	if(60<(((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk()).length()){
		        		row.setHeightInPoints((short)(22*((((W83bSindicatosBean)listaSindicatos.get(i)).getDescSindicatoEusk()).length()/60)+1));
		        	}
		        }
        	}
        }
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoSindicatos.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	/**
	 * Estilo fila.
	 * 
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
		
	/**
	 * Estilo fila numero centrado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaNumeroCentrado(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;//NOPMD
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	/**
	 * Estilo fila justificado.
	 *
	 * @param nFila the n fila
	 * @param excel the excel
	 * @param wb the wb
	 * @return the hSSF cell style
	 */
	private HSSFCellStyle estiloFilaJustificado(int nFila, W83bUtilidadesExcel excel, HSSFWorkbook wb){
		return excel.styleFilaJustificado;
	}
}
